package gov.va.med.mhv.integration.phr.message;

import gov.va.med.mhv.integration.phr.service.PhrProcessor;
import gov.va.med.mhv.integration.phr.service.ServiceResponse;
import gov.va.med.mhv.integration.phr.stage.transfer.StageMessageControl;

/** Marker interface for classes that can process a message.
 * Implementing classes should use the @MessageSelector annotation to
 * define the message selector for receiving messages.
 * User: Rob Murtha
 * @see MessageSelector
 */
public interface MessageProcessor  extends PhrProcessor {
    public ServiceResponse process(StageMessageControl message);
    public void setMaxRetries(long retries);
    public void setRetryDelay(long delayMs);
    public long getMaxRetries();
    public long getRetryDelay();
}
